/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.text.DecimalFormat;
import java.util.List;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandAutonumber
extends SingleLineCommand<SequenceDiagram> {
    public CommandAutonumber() {
        super("(?i)^autonumber[%s]*(\\d+)?(?:[%s]+(\\d+))?(?:[%s]+[%g]([^%g]+)[%g])?[%s]*$");
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, List<String> arg) {
        DecimalFormat decimalFormat;
        int start = 1;
        if (arg.get(0) != null) {
            start = Integer.parseInt(arg.get(0));
        }
        int inc = 1;
        if (arg.get(1) != null) {
            inc = Integer.parseInt(arg.get(1));
        }
        String df = arg.get(2) == null ? "<b>0</b>" : arg.get(2);
        try {
            decimalFormat = new DecimalFormat(df);
        }
        catch (IllegalArgumentException e) {
            return CommandExecutionResult.error("Error in pattern : " + df);
        }
        sequenceDiagram.autonumberGo(start, inc, decimalFormat);
        return CommandExecutionResult.ok();
    }
}

